#!/ffp/bin/sh

# PROVIDES: mlnet

. /ffp/etc/ffp.subr

export MLDONKEY_DIR=/mnt/HD_a2/mldonkey
export MLDONKEY_TEMP=$MLDONKEY_DIR/temp

name="mlnet"
command="/ffp/bin/mlnet"
start_cmd="mlnet_start"
stop_cmd="mlnet_stop"
status_cmd="mlnet_status"
user=nobody

mlnet_start()
{
	if [ ! -d $MLDONKEY_DIR ]; then
		su $user -c "mkdir $MLDONKEY_DIR"
	fi
	echo "Starting $name"
	su $user -c "$command >$MLDONKEY_DIR/$name.log 2>&1 &"
	sleep 1
}

mlnet_stop()
{
	if [ -f $MLDONKEY_DIR/$name.pid ]; then
		echo "Stopping $name"
		/bin/kill `cat $MLDONKEY_DIR/$name.pid`
		rm -f $MLDONKEY_DIR/$name.pid
	else
		echo "$name is not running"
	fi
}

run_rc_command "$1"
